<?php

class MainController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'index';
	public $menu = array(
				array('url'=>array('/administration/main/index'), 'label'=>'Panel główny'),
				array('url'=>array('/administration/school/index'), 'label'=>'Szkoły'),
				array('url'=>array('/administration/firma'), 'label'=>'Firmy'),
				array('url'=>array('/administration/main/statistics'), 'label'=>'Statystyki'),
				array('label'=>'Konfiguracja gry',
						'items'=>array(
						array('url'=>array('/administration/gameParameters/admin'), 'label'=>'Parametry gry'),
						array('url'=>array('/administration/bank/admin'), 'label'=>'Banki'),
						array('url'=>array('/administration/budynek/admin'), 'label'=>'Budynki'),
						array('url'=>array('/administration/biuro/admin'), 'label'=>'Biura'),
						array('url'=>array('/administration/kampanie/admin'), 'label'=>'Kampanie'),
						array('url'=>array('/administration/kontrahent/admin'), 'label'=>'Kontrahenci'),
						array('url'=>array('/administration/lekcja/admin'), 'label'=>'Lekcje'),
						array('url'=>array('/administration/dialog/admin'), 'label'=>'Dialogi'),
						array('url'=>array('/administration/akcja/admin'), 'label'=>'Akcje'),
						array('url'=>array('/administration/zlecenie/admin'), 'label'=>'Zlecenia'),
						// Zadaniami szkoleniowymi (egzaminami) zarządzamy teraz przez moduł "Zlecenia",
						// mechanizm administracji szkoleniami służy teraz tylko do wprowadzania treści szkoleń
						array('url'=>array('/administration/szkolenie/admin'), 'label'=>'Szkolenia'),
						array('url'=>array('/administration/pracownik/admin'), 'label'=>'Pracownicy'),
						array('url'=>array('/administration/tura/admin'), 'label'=>'Tury'),
					),
					'linkOptions'=>array('class'=>'submenuTitle configurationSubmenu',
											'onclick'=>'$(this).next("ul").slideToggle()',
					)),
				array('label'=>'Użytkownicy',
						'items'=>array(
						array('url'=>array('/administration/uzytkownik'), 'label'=>'Uczniowie'),
						array('url'=>array('/administration/main/inactiveStudents'), 'label'=>'Nieaktywni uczniowie'),
						array('url'=>array('/administration/nauczyciel'), 'label'=>'Nauczyciele'),
						array('url'=>array('/administration/admin'), 'label'=>'Administratorzy'),
						array('url'=>array('/administration/schoolAdmin'), 'label'=>'Administratorzy szkół'),
					),
					'linkOptions'=>array('class'=>'submenuTitle usersSubmenu','onclick'=>'$(this).next("ul").slideToggle()')),
				array('url'=>array('/administration/main/account'), 'label'=>'Moje konto'),
			);

	public function getMenu()
	{
		$schoolId = Yii::app()->user->getState('schoolId');

		$adminMenu = array(
			array('url'=>array('/administration/main/index'), 'label'=>'Panel główny'),
			array('url'=>array('/administration/school/index'), 'label'=>'Szkoły'),
			array('url'=>array('/administration/firma'), 'label'=>'Firmy'),
			array('url'=>array('/administration/main/statistics'), 'label'=>'Statystyki'),
			array('label'=>'Konfiguracja gry',
					'items'=>array(
					array('url'=>array('/administration/gameParameters/admin'), 'label'=>'Parametry gry'),
					array('url'=>array('/administration/bank/admin'), 'label'=>'Banki'),
					array('url'=>array('/administration/budynek/admin'), 'label'=>'Budynki'),
					array('url'=>array('/administration/biuro/admin'), 'label'=>'Biura'),
					array('url'=>array('/administration/kampanie/admin'), 'label'=>'Kampanie'),
					array('url'=>array('/administration/kontrahent/admin'), 'label'=>'Kontrahenci'),
					array('url'=>array('/administration/lekcja/admin'), 'label'=>'Lekcje'),
					array('url'=>array('/administration/dialog/admin'), 'label'=>'Dialogi'),
					array('url'=>array('/administration/akcja/admin'), 'label'=>'Akcje'),
					array('url'=>array('/administration/zlecenie/admin'), 'label'=>'Zlecenia'),
					// Zadaniami szkoleniowymi (egzaminami) zarządzamy teraz przez moduł "Zlecenia",
					// mechanizm administracji szkoleniami służy teraz tylko do wprowadzania treści szkoleń
					array('url'=>array('/administration/szkolenie/admin'), 'label'=>'Szkolenia'),
					array('url'=>array('/administration/pracownik/admin'), 'label'=>'Pracownicy'),
					array('url'=>array('/administration/tura/admin'), 'label'=>'Tury'),
				),
				'linkOptions'=>array('class'=>'submenuTitle configurationSubmenu',
										'onclick'=>'$(this).next("ul").slideToggle()',
				)),
			array('label'=>'Użytkownicy',
					'items'=>array(
					array('url'=>array('/administration/uzytkownik'), 'label'=>'Uczniowie'),
					array('url'=>array('/administration/main/inactiveStudents'), 'label'=>'Nieaktywni uczniowie'),
					array('url'=>array('/administration/nauczyciel'), 'label'=>'Nauczyciele'),
					array('url'=>array('/administration/admin'), 'label'=>'Administratorzy'),
					array('url'=>array('/administration/schoolAdmin'), 'label'=>'Administratorzy szkół'),
				),
				'linkOptions'=>array('class'=>'submenuTitle usersSubmenu','onclick'=>'$(this).next("ul").slideToggle()')),
			array('url'=>array('/administration/main/account'), 'label'=>'Moje konto'),
			array('url'=>array('/administration/main/deleteSchoolYearData'), 'label'=>'Usuń dane'),
		);

		$schoolAdminMenu = array(
			array('url'=>array('/administration/main/index'), 'label'=>'Panel główny'),
			array('url'=>$schoolId !== null ? array('/administration/klasa/admin', 'schoolId'=>$schoolId) : array('/administration/main/index'), 'label'=>'Klasy'),
			array('url'=>array('/administration/firma'), 'label'=>'Firmy'),
			array('url'=>$schoolId !== null ? array('/administration/main/statistics', 'schoolId'=>$schoolId) : array('/administration/main/index'), 'label'=>'Statystyki'),
			array('url'=>array('/administration/main/schoolToplists'), 'label'=>'Toplisty'),
			array('label'=>'Konfiguracja gry',
				'items'=>array(
//				array('url'=>array('/administration/lekcja/admin'), 'label'=>'Lekcje'),
				array('url'=>array('/administration/szkolenie/reportedExams'), 'label'=>'Szkolenia'),
				array('url'=>array('/administration/zlecenie/solutions'), 'label'=>'Zlecenia'),
				array('url'=>array('/administration/zlecenie/reportedAuctions'), 'label'=>'Przetargi'),

				array('url'=>array('/administration/tura/admin'), 'label'=>'Tury'),
			),
			'linkOptions'=>array('class'=>'submenuTitle configurationSubmenu',
									'onclick'=>'$(this).next("ul").slideToggle()',
			)),
			array('label'=>'Użytkownicy',
				'items'=>array(
				array('url'=>array('/administration/uzytkownik'), 'label'=>'Uczniowie'),
				array('url'=>array('/administration/main/inactiveStudents'), 'label'=>'Nieaktywni uczniowie'),
				array('url'=>array('/administration/nauczyciel'), 'label'=>'Nauczyciele'),
			),
				'linkOptions'=>array('class'=>'submenuTitle usersSubmenu','onclick'=>'$(this).next("ul").slideToggle()')),
			array('url'=>array('/administration/main/account'), 'label'=>'Moje konto'),
			array('url'=>array('/administration/main/deleteSchoolYearData'), 'label'=>'Usuń dane'),
		);

		if(isset(Yii::app()->user->role) && Yii::app()->user->role == 'admin')
			return $adminMenu;
		elseif(isset(Yii::app()->user->role) && Yii::app()->user->role == 'schoolAdmin')
			return $schoolAdminMenu;

		return array();
	}

	public function init()
	{
		$this->menu = $this->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow users to perform actions
				'actions'=>array('error','login','logout','forgottenPassword','passwordRecovery','getMessages'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform actions
				'actions'=>array('index','parameters','statistics','toplist','account',
						'inactiveStudents','activateGroups','rejectGroups','getFile','deleteSchoolYearData'),
				//'users'=>array('@'),
				'roles'=>array('admin')
			),
			array('allow', // allow authenticated user to perform actions
				'actions'=>array('index','parameters','statistics','toplist','account',
						'inactiveStudents','activateGroups','rejectGroups', 'schoolToplists','deleteSchoolYearData'),
				//'users'=>array('@'),
				'roles'=>array('schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actionIndex()
	{
		$this->render('index');
	}

	public function actionError()
	{
	    if($error = Yii::app()->errorHandler->error)
	    {
	    	if(Yii::app()->request->isAjaxRequest)
	    		echo $error['message'];
	    	else
	        	$this->render('error', $error);
	    }
	}

	public function actionLogin()
	{
		if(!Yii::app()->user->isGuest)
		{
			Yii::app()->user->logout();
			$this->redirect(array('login'));
		}

		$this->menu = array();

		$model = new UserAdministratorLoginForm;

		if(isset($_POST['UserAdministratorLoginForm']))
		{
			$model->attributes = $_POST['UserAdministratorLoginForm'];

			if($model->validate() && $model->login())
			{
				if(Yii::app()->user->getState('role') == 'teacher')
					Klasa::createTestClassIfNotExists();
				if(Yii::app()->user->getIsAdministrator() || Yii::app()->user->getIsSchoolAdministrator())
					$this->redirect(array('/administration/main/index'));
				else
					$this->redirect(array('/teacher/main/index'));
			}
		}

		$this->render('login', array('model'=>$model));
	}

	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(array('/administration/main/login'));
	}

	public function actionForgottenPassword()
	{
		$model = new UserAdministratorPasswordForm('sendEmail');

		if(isset($_POST['UserAdministratorPasswordForm']))
		{
			$model->attributes = $_POST['UserAdministratorPasswordForm'];

			if($model->validate())
			{
				$model->userModel->kodDoOdzyskaniaHasla = md5(time().rand());
				$mailMessages = ParametryGry::model()->findAll('"nazwa" IN (\'ODZYSKANIE_HASLA_ADMINISTRATORA_TEMAT_WIADOMOSCI\', \'ODZYSKANIE_HASLA_ADMINISTRATORA_TRESC_WIADOMOSCI\')', array('order'=>'"nazwa"'));

				$subject = $mailMessages[0]->wartosc;
				$message = $mailMessages[1]->wartosc;

				$subject = str_replace('<imie>',$model->userModel->imie,$subject);
				$subject = str_replace('<nazwisko>',$model->userModel->nazwisko,$subject);

				$message = str_replace('<imie>',$model->userModel->imie,$message);
				$message = str_replace('<nazwisko>',$model->userModel->nazwisko,$message);
				$message = str_replace('<link>',$this->createAbsoluteUrl('passwordRecovery',array('code'=>$model->userModel->kodDoOdzyskaniaHasla)),$message);

				$to      = $model->userModel->email;
				$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
				    'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
				    'X-Mailer: PHP/' . phpversion();

				mail($to, $subject, $message, $headers);

				$model->userModel->save(false);

				Yii::app()->user->setFlash('emailSent','Na Twój adres e-mail wysłaliśmy dalsze instrukcje.');
			}
		}

		$this->render('forgottenPassword',
			array('model'=>$model)
		);
	}

	public function actionPasswordRecovery($code)
	{
		$user = Admin::model()->findByAttributes(array('kodDoOdzyskaniaHasla'=>$code));
		if (!$user)
			$user = Uzytkownik::model()->findByAttributes(array('kodDoOdzyskaniaHasla'=>$code));
		if(!$user)
			throw new CHttpException(404,'Podana strona nie istnieje.');

		$model = new UserAdministratorPasswordForm('setPassword');

		if(isset($_POST['UserAdministratorPasswordForm']))
		{
			$model->attributes = $_POST['UserAdministratorPasswordForm'];
			if($model->validate())
			{
				$user->haslo = hash('sha1', $model->password);
				$user->kodDoOdzyskaniaHasla = '';
				$user->save(false);

				Yii::app()->user->setFlash('passwordChanged','Twoje hasło zostało zmienione, możesz teraz się zalogować.');
			}
		}

		$this->render('passwordRecovery',array(
			'model'=>$model
		));
	}

	public function actionParameters()
	{
		$rawData = array(
			array('id'=>'1', 'name'=>'Początkowa liczba zleceń gracza', 'value'=>'5'),
			array('id'=>'2', 'name'=>'Czas na otworzenie zlecenia przed wygaśnięciem', 'value'=>'7'),
			array('id'=>'3', 'name'=>'Czas na rozwiązanie zlecenia', 'value'=>'20'),
		);

		$dataProvider = new CArrayDataProvider($rawData, array(
			'id'=>'id',
			'pagination'=>array(
				'pageSize'=>30,
			),
		));

		$this->render('parameters', array(
			'dataProvider'=>$dataProvider,
		));
	}

	public function actionStatistics($schoolId = null,$classId = null,$companyId = null,$studentId = null)
	{
		if(!empty($schoolId))
		{
			$classesDataProvider = Klasa::model()->getAllStatisticsBySchool($schoolId);
			$model = Szkola::model()->findByPk($schoolId);

			$schoolid = Yii::app()->user->getState('schoolId');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($schoolid) && $model->id !== Yii::app()->user->getState('schoolId'))
				throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

			$companyDataJsObject = array();

			foreach($classesDataProvider->data as $row)
				$companyDataJsObject[$row["nazwa"]." ".$row["idKlasy"]] = $row["punkty"];

			$this->render('statisticsSchool',array(
				'classesDataProvider'=>$classesDataProvider,
				'companyDataJsObject'=>CJavaScript::encode($companyDataJsObject),
				'model'=>$model
			));
		}
		else if(!empty($classId))
		{
			$companiesDataProvider = Firma::model()->getAllStatisticsByClass($classId);
			$studentPointsDataProvider = Uzytkownik::model()->getAllStatistics($classId);
			$model = Klasa::model()->findByPk($classId);

			$classese = Yii::app()->user->getState('classes');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($classese) && !in_array($model->id, Yii::app()->user->getState('classes')))
				throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

			$studentDataArray = array();

			foreach($studentPointsDataProvider->data as $row)
				$studentDataArray[$row["imie"]." ".$row["nazwisko"]." ".$row["id"]] = $row["punkty"];

			$companyDataArray = array();

			foreach($companiesDataProvider->data as $row)
				$companyDataArray[$row["nazwa"]." ".$row["id"]] = $row["punkty"];

			$this->render('statisticsClass',array(
				'companiesDataProvider'=>$companiesDataProvider,
				'studentPointsDataProvider'=>$studentPointsDataProvider,
				'companyJsObject'=>CJavaScript::encode($companyDataArray),
				'studentJsObject'=>CJavaScript::encode($studentDataArray),
				'model'=>$model
			));
		}
		else if(!empty($companyId))
		{
			$model = Firma::model()->findByPk($companyId);

			$companiese = Yii::app()->user->getState('companies');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($model->id, Yii::app()->user->getState('companies')))
				throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

			$pointsDataProvider = $model->getStatistics();

			$dataArray = array();

			foreach($pointsDataProvider->data as $row)
				$dataArray[$row["nazwa"]] = $row["punkty"];

			$this->render('statisticsCompany',array(
				'pointsDataProvider'=>$pointsDataProvider,
				'model'=>$model,
				'dataJsObject'=>CJavaScript::encode($dataArray)
			));
		}
		else if(!empty($studentId))
		{
			$model = Uzytkownik::model()->findByPk($studentId);

			$classese = Yii::app()->user->getState('classes');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($classese) && !in_array($model->idKlasy, Yii::app()->user->getState('classes')))
				throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

			$pointsDataProvider = $model->getStatistics();

			$dataArray = array();

			foreach($pointsDataProvider->data as $row)
				$dataArray[$row["nazwa"]." ".$row["id"]] = $row["punkty"];

			$this->render('statisticsStudent',array(
				'pointsDataProvider'=>$pointsDataProvider,
				'model'=>$model,
				'dataJsObject'=>CJavaScript::encode($dataArray)
			));
		}
		else
		{
			$schoolsDataProvider = Szkola::model()->getAllStatistics();

			$dataArray = array();

			foreach($schoolsDataProvider->data as $row)
				$dataArray[$row["nazwa"]." ".$row["id"]] = $row["punkty"];

			$this->render('statistics',array(
				'schoolsDataProvider'=>$schoolsDataProvider,
				'dataJsObject'=>CJavaScript::encode($dataArray)
			));
		}
	}

        public function actionToplist($listType = null)
        {
        	$model = array();
                $classesDataProviders = array();
                $dataProvider = null;
                if($listType == 'class')
                {
                	$iid = 0;
                	$schoolsDataProvider = Szkola::model()->getAllStatistics();
                	$model = Szkola::model()->findAll();

                	foreach($schoolsDataProvider->data as $srow)
                	{
                		$schoolId = $srow["id"];
                		$classesDataProviders[$iid] = Klasa::model()->getAllStatisticsBySchool($schoolId);
                		$iid++;
                	}

                	$resultArray = array();
                	for($i=0;$i<$iid;$i++)
                	{
                		foreach($classesDataProviders[$i]->data as $row)
                		{
                			if($row['czyTestowa']=='0' && isset($row['idSzkoly']))
                			{
                				$resultObject["id"] = $row["idKlasy"];
                				$resultObject["nazwa"] = $row["nazwa"];
                				$szkola = Szkola::model()->find('"id"='.$row["idSzkoly"]);
                				$resultObject["szkola"] = $szkola->nazwa;
                				$resultObject["punkty"] = $row["punkty"];
                				array_push($resultArray, $resultObject);
                			}
                		}
                	}

                	$dataProvider = new CArrayDataProvider($resultArray, array(
                		'id'=>'idKlasy',
                		'sort'=>array(
                			'attributes'=>array(
                				'punkty', 'nazwa'
                				),
                			'defaultOrder'=>array(
                				'punkty'=>SORT_DESC
                				)
                			),
                		'pagination'=>array(
                			'pageSize'=>100,
                			),

                		));
                }
                else if($listType == 'student')
                {
                	$dataProvider = Uzytkownik::model()->getAllStatisticsTotal();
                	$dataProvider->setSort(array(
                		'attributes'=>array(
                			'"punkty"'
                			),
                		'defaultOrder'=>array(
                			'"punkty"'=>SORT_DESC
                			)
                		)
                	);
                	// $dataProvider->setPagination(array(
                	// 	'pageSize'=>100,
                	// 	)
                	// );
                }
                else if($listType == 'company')
                {
                	$dataProvider = Firma::model()->getAllStatisticsTotal();
                	$dataProvider->setSort(array(
                		'attributes'=>array(
                			'"punkty"'
                			),
                		'defaultOrder'=>array(
                			'"punkty"'=>SORT_DESC
                			)
                		)
                	);
                	// $dataProvider->setPagination(array(
                	// 	'pageSize'=>100,
                	// 	)
                	// );
                }

                $this->render('toplist',array(
                        'listType'=>$listType,
                        'data'=>$dataProvider,
                        'model'=>$model
                ));
        }

	public function actionAccount()
	{
		$model = Admin::model()->findByPk(Yii::app()->user->id);
		$currentPassword = $model->haslo;

		if(isset($_POST['Admin']))
		{
			$model->attributes = $_POST['Admin'];

			if($model->validate())
			{
				if(!empty($model->haslo))
					$model->haslo = hash('sha1', $model->haslo);
				else
					$model->haslo = $currentPassword;

				$model->save(false);
				Yii::app()->user->setFlash('accountUpdated', 'Konto zostało pomyślnie zaktualizowane.');
				$this->redirect(array('account'));
			}
		}
		$model->haslo = '';
		$model->hasloPowtorzone = '';

		$this->render('account',array('model'=>$model));
	}

	public function actionInactiveStudents()
	{
		$schools = Szkola::model()->findAll();

		$this->render('inactiveStudents',array(
			'schools'=>$schools,
		));
	}

	public function actionActivateGroups()
	{
		$companiesToActivation = array();
		$companiesToAssignment = array();

		$usersActivated = 0;

		if(!isset($_POST['Group']))
			$this->redirect(Yii::app()->request->getUrlReferrer());
		
		foreach($_POST['Group'] as $id=>$group)
		{
			if(!isset($group['selected']))
				continue;
			if($group['assign'] == 'newCompany')
				$companiesToActivation[] = Yii::app()->db->quoteValue($id);
			else
				$companiesToAssignment[] = Yii::app()->db->quoteValue($id);
		}

		if(!empty($companiesToActivation))
		{
			$sql = 'UPDATE "Firma"
				SET "status" = '.Firma::COMPANY_STATUS_ACTIVE.'
				WHERE "id" IN ('.implode(',',$companiesToActivation).')';

			Yii::app()->db->createCommand($sql)->execute();
		}

		if(!empty($companiesToAssignment) || !empty($companiesToActivation))
		{
			$sql = 'UPDATE "Uzytkownik" t
				SET t."status" = '.Uzytkownik::USER_STATUS_ACTIVE.'
				WHERE t."idFirmy" IN ('.implode(',',array_merge($companiesToActivation,$companiesToAssignment)).')';

			$usersActivated = Yii::app()->db->createCommand($sql)->execute();
		}

		foreach($companiesToAssignment as $companyId)
		{
			$sql = 'UPDATE "Uzytkownik" t
				SET t."status" = '.Uzytkownik::USER_STATUS_ACTIVE.', t."idFirmy" = :existingCompanyId
				WHERE t."id" IN (SELECT t2."id" FROM "Uzytkownik" t2 WHERE t2."idFirmy"= :companyToAssignment)';

			$usersActivated += Yii::app()->db->createCommand($sql)->execute(array(':existingCompanyId'=>$_POST['Group'][$companyId]['existingCompany'], ':companyToAssignment'=>$companyId));

			$sql = 'DELETE FROM "DziedzinaFirmy" WHERE "idFirmy" = :companyToAssignment';

			Yii::app()->db->createCommand($sql)->execute(array(':companyToAssignment'=>$companyId));

			$sql = 'DELETE FROM "Firma"
				WHERE "id" = :companyToAssignment AND "status" = '.Firma::COMPANY_STATUS_INACTIVE;

			Yii::app()->db->createCommand($sql)->execute(array(':companyToAssignment'=>$companyId));
		}

		$infoMessage = $usersActivated>1?'Uzytkownicy zostali aktywowani.':'Użytkownik został aktywowany';

		Yii::app()->user->setFlash('groupActivated',$infoMessage);

		$this->redirect(Yii::app()->request->getUrlReferrer());
	}

	public function actionRejectGroups($companyIds)
	{
		if(empty($companyIds))
			$this->redirect(Yii::app()->request->getUrlReferrer());
		
		$sql = 'DELETE "DziedzinaUzytkownika"
			WHERE "idUzytkownika" IN (SELECT t."id" FROM "Uzytkownik" t WHERE t."idFirmy" IN ('.$companyIds.'))';

		Yii::app()->db->createCommand($sql)->execute();

		$sql = 'DELETE "Uzytkownik" t
			WHERE t."status" = '.Uzytkownik::USER_STATUS_INACTIVE.' AND t."idFirmy" IN ('.$companyIds.')';

		$sql = 'DELETE "DziedzinaFirmy"
			WHERE "idFirmy" IN ('.$companyIds.')';

		Yii::app()->db->createCommand($sql)->execute();

		$sql = 'DELETE "Firma"
			WHERE "status" = '.Firma::COMPANY_STATUS_INACTIVE.' AND "id" IN ('.$companyIds.')';

		Yii::app()->db->createCommand($sql)->execute();

		Yii::app()->user->setFlash('groupActivated','Uzytkownicy zostali odrzuceni.');

		$this->redirect(Yii::app()->request->getUrlReferrer());
	}

	public function actionGetFile($name)
	{
		$name = filter_var($name, FILTER_VALIDATE_REGEXP,array('options' => array(
			'regexp' => '/^[a-zA-Z0-9]{1,}\.[a-zA-Z0-9]{1,}$/'
		)));

		$path = Yii::getPathOfAlias('administration.hiddenFiles') . '/' . $name;

		if (file_exists($path) && !is_dir($path))
		{
			header('Content-Length: ' . filesize($path));
			header('Content-Type: ' . CFileHelper::getMimeType($path));
			header('Content-Disposition: inline; filename="' . $name . '"');
			echo file_get_contents($path);
		}
		else throw new CHttpException(404, 'Not found');
	}

	public function actionGetMessages()
	{
		if(!Yii::app()->user->isGuest)
		{
                	if(in_array($_POST['from'], array('zlecenie','solutions','login')))
                	{
                        	echo json_encode(array());
                        	return;
                	}

			$messages = array();

			$condition = '"zgloszone" IS NOT NULL';
			$companiese = Yii::app()->user->getState('companies');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese))
				$condition = '"zgloszone" IS NOT NULL AND "idFirmy" IN ('.implode(',', Yii::app()->user->getState('companies')).')';
			elseif(Yii::app()->user->role == 'schoolAdmin' && empty($companiese))
				$condition = null;
			
			if($condition !== null)
				$numberOfReportedTasks = count(ZlecenieFirmy::model()->findAll(array(
					'condition' => $condition
				)));
			else
				$numberOfReportedTasks = 0;

			$condition = '"zgloszone" IS NOT NULL';
			$companiese = Yii::app()->user->getState('companies');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese))
				$condition = '"zgloszone" IS NOT NULL AND "idFirmy" IN ('.implode(',', Yii::app()->user->getState('companies')).')';
			elseif(Yii::app()->user->role == 'schoolAdmin' && empty($companiese))
				$condition = null;
			
			if($condition !== null)
				$numberOfReportedExams = count(SzkolenieFirmy::model()->findAll(array(
					'condition' => $condition
				)));
			else
				$numberOfReportedExams = 0;

			$condition = '"zgloszone" IS NOT NULL';
			$tenderse = Yii::app()->user->getState('tenders');
			if(Yii::app()->user->role == 'schoolAdmin' && !empty($tenderse))
				$condition = '"zgloszone" IS NOT NULL AND "id" IN ('.implode(',', Yii::app()->user->getState('tenders')).')';
			elseif(Yii::app()->user->role == 'schoolAdmin' && empty($tenderse))
				$condition = null;
			
			if($condition !== null)
				$numberOfReportedTenders = count(PrzetargGrupa::model()->findAll(array(
					'condition' => $condition
				)));
			else
				$numberOfReportedTenders = 0;

			if($numberOfReportedTasks)
				$messages[] = 'Masz '.$numberOfReportedTasks.' zakwestionowanych zadań. <a href="'.Yii::app()->createUrl('/administration/zlecenie/solutions').'">Kliknij tutaj</a>, aby zweryfikować.';

			if($numberOfReportedExams)
				$messages[] = 'Masz '.$numberOfReportedExams.' zakwestionowanych egzaminów. <a href="'.Yii::app()->createUrl('/administration/szkolenie/reportedExams').'">Kliknij tutaj</a>, aby zweryfikować.';

			if($numberOfReportedTenders)
				$messages[] = 'Masz '.$numberOfReportedTenders.' zakwestionowanych przetargów. <a href="'.Yii::app()->createUrl('/administration/zlecenie/reportedAuctions').'">Kliknij tutaj</a>, aby zweryfikować.';

			echo json_encode($messages);
		}
	}

	public function actionSchoolToplists()
	{
		$this->render('schoolToplists');
	}
	
	public function actionDeleteSchoolYearData()
	{
		if(isset($_POST['accept']))
		{
			//lista tabel, na ktorych trzeba zrobic TRUNCATE
			$tableNames = array(
				'UzytkownikObecnosc'=>'idUzytkownika',
				'Tura'=>'idKlasy',
				'BiuroFirmy'=>'idFirmy',
				'KampaniaFirmy'=>'idFirmy',
				'DziedzinaFirmy'=>'idFirmy',
				'Faktury'=>'idFirmy',
				'ZlecenieFirmyLog'=>'',
				'ZlecenieFirmy'=>'idFirmy',
				'OplatyPracownicy'=>'idFirmy',
				'PrzetargFirma'=>'idFirmy',
				'PrzetargGrupa'=>'idPrzetargGrupa',
				'PracownikFirmy'=>'idFirmy',
				'Przetarg'=>'idKlasy',
				'SzkolenieFirmyOdp'=>'idSzkolenieFirmy',
				'SzkolenieOdpowiedziFirmy'=>'idSzkolenieFirmy',
				'SzkolenieFirmy'=>'idFirmy',
				'Oplaty'=>'idFirmy',
				'AkcjaUzytkownika'=>'idFirmy',
				'Firma'=>'idKlasy',
				'DziedzinaUzytkownika'=>'idUzytkownika',
				'SzkoleniePracownika'=>'idPracownika',
				'PracownikFirmy'=>'idFirmy',
				'FormularzUzytkownika'=>'idUzytkownika',
				'FormularzDane'=>'idFormularzUzytkownika',
				'Uzytkownik'=>'idKlasy',
				'Klasa'=>'idKlasyPK',
			);

			$db = Yii::app()->db;

			$classes = array();
			$companies = array();
			$tenders = array();
			$users = array();
			$formData = array();
			$companyTrainings = array();
			$companyWorkers = array();

			if(Yii::app()->user->role == 'schoolAdmin')
			{
				$classes = Yii::app()->user->getState('classes');
				$companies = Yii::app()->user->getState('companies');
				$tenders = Yii::app()->user->getState('tenders');

				if(!empty($classes))
					$users = $db->createCommand('SELECT "id" FROM "Uzytkownik" WHERE "idKlasy" IN ('.implode(',', $classes).')')->queryColumn();
				if(!empty($users))
					$formData = $db->createCommand('SELECT "id" FROM "FormularzUzytkownika" WHERE "idUzytkownika" IN ('.implode(',', $users).')')->queryColumn();
				if(!empty($companies))
					$companyTrainings = $db->createCommand('SELECT "id" FROM "SzkolenieFirmy" WHERE "idFirmy" IN ('.implode(',', $companies).')')->queryColumn();
				if(!empty($companies))
					$companyWorkers = $db->createCommand('SELECT "idPracownika" FROM "PracownikFirmy" WHERE "idFirmy" IN ('.implode(',', $companies).')')->queryColumn();

			}


			$transaction = $db->beginTransaction();
			try
			{
	//			$sqls = array();
				//czyszczenie tabel
				foreach($tableNames as $tableName=>$column)
				{
					$sql = "delete from \"$tableName\"";

					if(Yii::app()->user->role == 'admin')
					{
						$cmd = $db->createCommand($sql);
						$cmd->execute();
					}
					elseif(Yii::app()->user->role == 'schoolAdmin')
					{
						if($column == 'idKlasy' && !empty($classes))
						{
							$sql .= ' where "idKlasy" IN ('.implode(',',$classes).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idFirmy' && !empty($companies))
						{
							$sql .= ' where "idFirmy" IN ('.implode(',',$companies).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idUzytkownika' && !empty($users))
						{
							$sql .= ' where "idUzytkownika" IN ('.implode(',',$users).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idPrzetargGrupa' && !empty($tenders))
						{
							$sql .= ' where "id" IN ('.implode(',',$tenders).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idFormularzUzytkownika' && !empty($formData))
						{
							$sql .= ' where "id" IN ('.implode(',',$formData).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idSzkolenieFirmy' && !empty($companyTrainings))
						{
							$sql .= ' where "idSzkolenieFirmy" IN ('.implode(',',$companyTrainings).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idKlasyPK' && !empty($classes))
						{
							$sql .= ' where "id" IN ('.implode(',',$classes).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}
						elseif($column == 'idPracownika' && !empty($companyWorkers))
						{
							$sql .= ' where "idPracownika" IN ('.implode(',',$companyWorkers).')';
							$cmd = $db->createCommand($sql);
							$cmd->execute();
						}

	//					$sqls[] = $sql;
					}
				}
	//			CVarDumper::dump($sqls, 10, true);
	//			die();
				$transaction->commit();
			} 
			catch (Exception $ex)
			{
				$transaction->rollback();

				Yii::app()->user->setFlash('deleteSchoolYearDataFailure', 'Wystąpił błąd! Skontaktuj się z głównym administratorem.');
			}
			
			Yii::app()->user->setFlash('deleteSchoolYearDataSuccess', 'Dane zostały wyczyszczone.');
			$this->redirect(array('index'));
		}
		
		$this->render('deleteSchoolYearData');
	}
}
